/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlib;

import java.io.FileOutputStream;
import java.io.PrintStream;
import uk.co.demon.obelisk.xapp.Application;
import uk.co.demon.obelisk.xapp.Option;
import uk.co.demon.obelisk.xobj.Library;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Parser;

public abstract class Librarian
extends Application {
    private Option createOption = new Option("-create", "Create a library");
    private Option updateOption = new Option("-update", "Update objects in a library");
    private Option removeOption = new Option("-remove", "Removed objects from a library");
    private Option listOption = new Option("-list", "Lists objects in a library");
    private String libraryName;
    private Library library;

    protected void startUp() {
        super.startUp();
        int optionCount = 0;
        if (this.listOption.isPresent()) {
            ++optionCount;
        }
        if (this.createOption.isPresent()) {
            ++optionCount;
        }
        if (this.updateOption.isPresent()) {
            ++optionCount;
        }
        if (this.removeOption.isPresent()) {
            ++optionCount;
        }
        if (optionCount == 0) {
            this.error("No action (create/update/remove/list) was selected");
            this.setFinished(true);
            return;
        }
        if (optionCount > 1) {
            this.error("Only one action (create/update/remove/list) can be selected at a time");
            this.setFinished(true);
            return;
        }
        String[] arguments = this.getArguments();
        if (arguments.length < 1) {
            this.error("No library was specified.");
            this.setFinished(true);
            return;
        }
        this.libraryName = arguments[0];
        if (!this.listOption.isPresent() && arguments.length == 1) {
            this.error("No object modules specified on the command line");
            this.setFinished(true);
            return;
        }
        if (this.createOption.isPresent()) {
            this.library = new Library();
        } else {
            try {
                this.library = (Library)Parser.parse(this.libraryName);
            }
            catch (Exception error) {
                this.error("Serious I/O error while opening library");
                this.setFinished(true);
                return;
            }
        }
    }

    protected void execute() {
        if (this.listOption.isPresent()) {
            this.list();
            return;
        }
        if (this.createOption.isPresent()) {
            this.create();
        } else if (this.updateOption.isPresent()) {
            this.update();
        } else if (this.removeOption.isPresent()) {
            this.remove();
        }
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(this.libraryName));
            stream.println("<?xml version='1.0'?>" + this.library);
            stream.close();
        }
        catch (Exception error) {
            System.err.println("Error: Could not write library");
            System.exit(1);
        }
        this.setFinished(true);
    }

    protected String describeArguments() {
        return "library [objects ...]";
    }

    private void create() {
        String[] arguments = this.getArguments();
        int index = 1;
        while (index < arguments.length) {
            try {
                Module module = (Module)Parser.parse(arguments[index]);
                this.library.addModule(module);
                System.out.println("Added " + arguments[index]);
            }
            catch (Exception error) {
                this.error("Could not open module '" + arguments[index] + "'");
            }
            ++index;
        }
    }

    private void update() {
        String[] arguments = this.getArguments();
        int index = 1;
        while (index < arguments.length) {
            try {
                Module module = (Module)Parser.parse(arguments[index]);
                if (this.library.updateModule(module)) {
                    System.out.println("Updated " + arguments[index]);
                } else {
                    System.out.println("Added " + arguments[index]);
                }
            }
            catch (Exception error) {
                this.error("Could not open module '" + arguments[index] + "'");
            }
            ++index;
        }
    }

    private void remove() {
        String[] arguments = this.getArguments();
        int index = 1;
        while (index < arguments.length) {
            try {
                Module module = (Module)Parser.parse(arguments[index]);
                if (this.library.removeModule(module)) {
                    System.out.println("Removed " + arguments[index]);
                } else {
                    this.warning("Module '" + arguments[index] + "' not found");
                }
            }
            catch (Exception error) {
                this.error("Could not open module '" + arguments[index] + "'");
            }
            ++index;
        }
    }

    private void list() {
        Module[] modules = this.library.getModules();
        int index = 0;
        while (index < modules.length) {
            System.out.println(modules[index].getName());
            ++index;
        }
        this.setFinished(true);
    }

    private void error(String message) {
        System.err.print("Error: ");
        System.err.println(message);
    }

    private void warning(String message) {
        System.err.print("Warn: ");
        System.err.println(message);
    }
}

